local key = ModPath .. '	' .. RequiredScript
if _G[key] then return else _G[key] = true end

local function fs_from_complete_heist_stats_item(self, item)
	local heists
	if item.contact == 'all' then
		local lists = table.map_values(self.job_list)
		heists = table.list_union(unpack(lists))
	else
		heists = table.list_copy(self.job_list[item.contact])
	end

	local heists_nr = #heists
	local res = table.list_to_set(heists)

	local function get_todo()
		for _, job in ipairs(heists) do
			for _, difficulty in ipairs(item.difficulty) do
				if managers.statistics:completed_job(job, difficulty, item.one_down) > 0 then
					res[job] = nil
					break
				end
			end
		end
		return table.map_keys(res)
	end

	local function get_cached_todo()
		local managers_statistics = managers.statistics
		if not item.fs_cached_todo or not item.fs_t or managers_statistics.fs_changed_dt and managers_statistics.fs_changed_dt > item.fs_t then
			item.fs_t = managers_statistics.fs_changed_dt
			item.fs_cached_todo = get_todo()
		end
		return item.fs_cached_todo
	end

	return {
		persistent = true,
		is_list = true,
		get_todo_list = get_cached_todo,
		get = function ()
			return heists_nr - #get_cached_todo()
		end,
		checklist = heists,
		max = heists_nr,
		update = 'rarely'
	}
end

local fs_original_achievementstweakdata_initnonautogenerated = AchievementsTweakData._init_non_auto_generated
function AchievementsTweakData:_init_non_auto_generated(...)
	fs_original_achievementstweakdata_initnonautogenerated(self, ...)

	for k, v in pairs(self.complete_heist_stats_achievements) do
		if v.award and self.visual[v.award] then
			if self.visual[v.award].progress and self.visual[v.award].progress.get_todo_list then
				self.visual[v.award].progress = fs_from_complete_heist_stats_item(self, v)
			end
		end
	end
end
